c======================================================================
c d2h24n (D2h symmetry, A2B4 type Molecule (e. g. C2H4),
c                                             symOrb NON-SPIN version )
c  2011.02.16 Version 1.0 Sakane, Genta
c     ( Department of Chemistry, Okayama University of Science, Japan )
c======================================================================
      program d2h24n
      real*8 a(6,3),b(6,3),bohr,aaadis,aabdis,baadis,babdis,az,bz,ax,bx
     &,pi,rad,dbabang,rbabang,hfaaadis,hfbaadis,hfdbabang,hfrbabang
      integer z(6),n(6)
      open (unit=07, form='formatted', status='unknown',
     &      access='sequential', file='d2h24n.out')
      open (unit=08, form='formatted', status='unknown',
     &      access='sequential', file='f01')
      bohr=0.5291772108
      pi=3.1415926535
      rad=180/pi
      write(*,1010)
   10 write(*,1020)
      read(*,*) z(1)
      if(z(1).le.0) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 10
      else
      go to 20
      end if
   20 if(z(1).gt.94) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 10
      else
      go to 30
      end if
   30 write(*,1030)
      read(*,*) z(3)
      if(z(3).le.0) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 30
      else
      go to 40
      end if
   40 if(z(3).gt.94) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 30
      else
      go to 50
      end if
   50 write(*,1040)
      read(*,*) aaadis
      write(*,1050)
      read(*,*) aabdis
   60 write(*,1060)
      read(*,*) dbabang
      if(dbabang.le.0) then
      write(*,1610)
      write(*,1620)
      write(*,1630)
      go to 60
      else
      go to 70
      end if
   70 if(dbabang.ge.180) then
      write(*,1610)
      write(*,1620)
      write(*,1630)
      go to 60
      else
      go to 80
      end if
   80 baadis=aaadis/bohr
      babdis=aabdis/bohr
      hfaaadis=aaadis/2
      hfbaadis=baadis/2
      rbabang=dbabang/rad
      hfdbabang=dbabang/2
      hfrbabang=rbabang/2
      z(2)=z(1)
      z(4)=z(3)
      z(5)=z(3)
      z(6)=z(3)
      n(1)=1
      n(2)=1
      n(3)=2
      n(4)=2
      n(5)=2
      n(6)=2
      ax=aabdis*sin(hfrbabang)
      az=aabdis*cos(hfrbabang)
      bx=babdis*sin(hfrbabang)
      bz=babdis*cos(hfrbabang)
      a(1,1)=0
      a(1,2)=0
      a(1,3)=hfaaadis
      a(2,1)=0
      a(2,2)=0
      a(2,3)=-hfaaadis
      a(3,1)=0
      a(3,2)=ax
      a(3,3)=hfaaadis+az
      a(4,1)=0
      a(4,2)=-ax
      a(4,3)=hfaaadis+az
      a(5,1)=0
      a(5,2)=ax
      a(5,3)=-hfaaadis-az
      a(6,1)=0
      a(6,2)=-ax
      a(6,3)=-hfaaadis-az
      b(1,1)=0
      b(1,2)=0
      b(1,3)=hfbaadis
      b(2,1)=0
      b(2,2)=0
      b(2,3)=-hfbaadis
      b(3,1)=0
      b(3,2)=bx
      b(3,3)=hfbaadis+bz
      b(4,1)=0
      b(4,2)=-bx
      b(4,3)=hfbaadis+bz
      b(5,1)=0
      b(5,2)=bx
      b(5,3)=-hfbaadis-bz
      b(6,1)=0
      b(6,2)=-bx
      b(6,3)=-hfbaadis-bz
      write(7,3010)
      write(7,3020)
      write(7,3030)
      do 101 i=1,6
      write(7,1000) b(i,1),b(i,2),b(i,3),n(i)
  101 continue
      write(8,2010)
      do 201 i=1,6
      write(8,2020) z(i),n(i),a(i,1),a(i,2),a(i,3)
  201 continue
      write(8,2030)
      write(8,2040)
      write(8,2030)
      write(8,2050)
      write(8,2060)
      write(8,2070)
      write(8,2080)
      go to 204
  202 write(*,1001)
  203 write(*,1002)
  204 stop
 1000 format(3d20.10,i5)
 1001 format('*** Read Error ***')
 1002 format('*** Data Not Found ***')
 1010 format(/,'*** Program D2h24 (symOrb NON-SPIN version)',/,'*** for
     &A2B4 type molecule (e. g. C2H4)')
 1020 format(/,3x,'Input Atomic Number(Z) (1 < Z < 94) of Central Atom A
     &, Z = ? ',$)
 1030 format(/,3x,'Input Atomic Number(Z) (1 < Z < 94) of Terminal Atom
     &B, Z = ? ',$)
 1040 format(/,3x,'Input Distance(angstrom), A - A = ? ',$)
 1050 format(/,3x,'Input Distance(angstrom), A - B = ? ',$)
 1060 format(/,3x,'Input Angle(degree)( 0 deg.< Angle < 180 deg.), B-A-B
     & = ? ',$)
 1510 format(//,'     ***********************************************')
 1520 format('     *** Error *** Atomic Number(Z) (1 < Z < 94) ***')
 1530 format('     ***********************************************',/)
 1610 format(//,'     ***********************************************')
 1620 format('     *** Error *** B-A-B ( 0 deg.< Angle < 180 deg.)')
 1630 format('     ***********************************************',/)
 2010 format('| Z ||NEQ||   X    ||   Y    ||   Z    |')
 2020 format(2x,i3,1x,i4,3(f10.5))
 2030 format('---------------------------------------------')
 2040 format('|NEQ||  CHG   ||U/D||   RD   ||   VD   |    1')
 2050 format('    0     Unit     (0:angstrom  1:atomic)')
 2060 format('    0     Spin     (0:non-spin  1:spin  )')
 2070 format('    0     M.P.     (0:No        1:Yes   )')
 2080 format('20000     Sample Point ( <100000, =0 autoset )')
 3010 format('    8')
 3020 format('    1    1    1    1    1    1    1    1')
 3030 format('    1    1    1    1    1    1    1    1')
      end
